public class List {
    private Node head = null;

    public List(){
        head = null;
    }

    public Node getHead(){
        return head;
    }

    public boolean isEmpty(){
        return (head == null);
    }

    public void insertAtHead(Object data){
        Node newNode= new Node(data);
        newNode.setNext(head);
        head = newNode;
    }

    public void insertAtTail(Object data){
        if(isEmpty()){
            head = new Node(data);
        }
        else{
            Node newNode = new Node(data);
            Node current = head;
            while(current.getNext() != null){
                current = current.getNext();
            }
            current.setNext(newNode);
        }
    }

    public Object removeFirst(){ //IB OOP Extension not needed
        if(isEmpty()) {
            Node first = head;
            head = head.getNext();
            return first.getData();
        }
        else return "Empty list";
    }

    public Object removeLast(){ //IB OOP Extension not needed
        if(!isEmpty()){
            Node current = head;
            Node previous = null;
            while(current.getNext() != null){
                previous = current;
                current = current.getNext();
            }
            previous.setNext(null);
            return current.getData();
        }
        else return "Empty list";
    }

    public void insertInOrder(Object data){
        Node newNode = new Node(data);
        Node current = head;
        Node previous = null;
        if(data.toString().compareTo(head.toString()) < 1){
            newNode.setNext(head);
            head = newNode;
        }else{
            while(newNode.getData().toString().compareTo(current.getData().toString()) > 1
                    && current.getNext() != null){
                previous = current;
                current = current.getNext();
            }
            previous.setNext(newNode);
            newNode.setNext(current);
        }
    }

    public void delete(Object data){
        Node current = head;
        Node previous = null;
        if(head.getData().toString().equals(data.toString())){
            head = head.getNext();
        }
        while(current.getNext() != null){
            previous = current;
            current = current.getNext();
            if(current.getData().toString().equals(data.toString())){
                previous.setNext(current.getNext());
                break;
            }
        }
    }

    public void listAll(){
        Node current = head;
        while(current.getNext() != null){
            System.out.println(current.getData().toString());
            current.getNext();
        }
    }

 }
